/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.execution;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchsupport.xcontent.ObjectTreeXContent;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.watch.severity.SeverityMapping;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class WatchExecutionContextData
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(WatchExecutionContextData.class);
    private NestedValueMap data;
    private NestedValueMap item;
    private SeverityMapping.EvaluationResult severity;
    private TriggerInfo triggerInfo;
    private JodaCompatibleZonedDateTime executionTime;
    private WatchInfo watch;

    public WatchExecutionContextData() {
        this.data = new NestedValueMap();
        this.triggerInfo = new TriggerInfo();
    }

    public WatchExecutionContextData(WatchInfo watch) {
        this.data = new NestedValueMap();
        this.triggerInfo = new TriggerInfo();
        this.watch = watch;
    }

    public WatchExecutionContextData(NestedValueMap data) {
        this.data = data;
        this.triggerInfo = new TriggerInfo();
        this.watch = new WatchInfo(null, null);
    }

    public WatchExecutionContextData(NestedValueMap data, WatchInfo watch, TriggerInfo triggerInfo, JodaCompatibleZonedDateTime executionTime) {
        this.data = data;
        this.triggerInfo = triggerInfo;
        this.executionTime = executionTime;
        this.watch = watch;
    }

    private WatchExecutionContextData(NestedValueMap data, WatchInfo watch, TriggerInfo triggerInfo, JodaCompatibleZonedDateTime executionTime, SeverityMapping.EvaluationResult severity, NestedValueMap item) {
        this.data = data;
        this.triggerInfo = triggerInfo;
        this.executionTime = executionTime;
        this.severity = severity;
        this.item = item;
        this.watch = watch;
    }

    public Map<String, Object> getTemplateScriptParamsAsMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("data", this.getData());
        result.put("item", this.getItem());
        result.put("severity", this.severity != null ? this.severity.toMap() : null);
        result.put("trigger", this.triggerInfo != null ? this.triggerInfo.toMap() : null);
        result.put("execution_time", this.executionTime);
        result.put("watch", this.watch != null ? this.watch.toMap() : null);
        return result;
    }

    public NestedValueMap getData() {
        return this.data;
    }

    public void setData(NestedValueMap data) {
        this.data = data;
    }

    public SeverityMapping.EvaluationResult getSeverity() {
        return this.severity;
    }

    public void setSeverity(SeverityMapping.EvaluationResult severity) {
        this.severity = severity;
    }

    public TriggerInfo getTriggerInfo() {
        return this.triggerInfo;
    }

    public void setTriggerInfo(TriggerInfo triggerInfo) {
        this.triggerInfo = triggerInfo;
    }

    public JodaCompatibleZonedDateTime getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(JodaCompatibleZonedDateTime executionTime) {
        this.executionTime = executionTime;
    }

    public WatchExecutionContextData clone() {
        return new WatchExecutionContextData(this.data.clone(), this.watch, this.triggerInfo, this.executionTime, this.severity, this.item);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("watch", (ToXContent)this.watch);
        builder.field("data", (Map)this.data);
        builder.field("severity", (ToXContent)this.severity);
        builder.field("trigger", (ToXContent)this.triggerInfo);
        builder.field("execution_time", (Object)this.executionTime);
        builder.endObject();
        return builder;
    }

    public static WatchExecutionContextData create(DocNode jsonNode) {
        WatchExecutionContextData result = new WatchExecutionContextData();
        if (jsonNode.hasNonNull("data")) {
            try {
                result.data = NestedValueMap.createUnmodifieableMap(jsonNode.getAsNode("data").toMap());
            }
            catch (Exception e) {
                log.error("Error while parsing " + jsonNode.get("data"), (Throwable)e);
            }
        }
        if (jsonNode.hasNonNull("severity")) {
            try {
                result.severity = SeverityMapping.EvaluationResult.create(jsonNode.getAsNode("severity"));
            }
            catch (Exception e) {
                log.error("Error while parsing " + jsonNode.get("severity"), (Throwable)e);
            }
        }
        if (jsonNode.hasNonNull("watch")) {
            try {
                result.watch = WatchInfo.create(jsonNode.getAsNode("watch"));
            }
            catch (Exception e) {
                log.error("Error while parsing " + jsonNode.get("watch"), (Throwable)e);
            }
        }
        if (jsonNode.hasNonNull("trigger")) {
            try {
                result.triggerInfo = TriggerInfo.create(jsonNode.getAsNode("trigger"));
            }
            catch (Exception e) {
                log.error("Error while parsing " + jsonNode.get("trigger"), (Throwable)e);
            }
        }
        if (jsonNode.hasNonNull("execution_time")) {
            try {
                result.executionTime = WatchExecutionContextData.parseJodaCompatibleZonedDateTime(jsonNode.getAsString("execution_time"));
            }
            catch (Exception e) {
                log.error("Error while parsing " + jsonNode.get("execution_time"), (Throwable)e);
            }
        }
        return result;
    }

    private static JodaCompatibleZonedDateTime toJoda(Date date) {
        if (date == null) {
            return null;
        }
        return new JodaCompatibleZonedDateTime(date.toInstant(), (ZoneId)ZoneOffset.UTC);
    }

    static JodaCompatibleZonedDateTime parseJodaCompatibleZonedDateTime(String value) {
        ZonedDateTime dt = ZonedDateTime.parse(value);
        return new JodaCompatibleZonedDateTime(dt.toInstant(), dt.getZone());
    }

    public NestedValueMap getItem() {
        return this.item;
    }

    public void setItem(NestedValueMap item) {
        this.item = item;
    }

    public WatchInfo getWatch() {
        return this.watch;
    }

    public void setWatch(WatchInfo watch) {
        this.watch = watch;
    }

    public static class WatchInfo
    implements ToXContentObject {
        public final String id;
        public final String tenant;

        public WatchInfo(String id, String tenant) {
            this.id = id;
            this.tenant = tenant;
        }

        public String getId() {
            return this.id;
        }

        public String getTenant() {
            return this.tenant;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("id", this.id);
            builder.field("tenant", this.tenant);
            builder.endObject();
            return builder;
        }

        public Map<String, Object> toMap() {
            return ObjectTreeXContent.toMap((ToXContent)this);
        }

        public static WatchInfo create(DocNode jsonNode) {
            String id = null;
            String tenant = null;
            if (jsonNode.hasNonNull("id")) {
                id = jsonNode.getAsString("id");
            }
            if (jsonNode.hasNonNull("tenant")) {
                tenant = jsonNode.getAsString("tenant");
            }
            return new WatchInfo(id, tenant);
        }
    }

    public static class TriggerInfo
    implements ToXContentObject {
        public final JodaCompatibleZonedDateTime triggeredTime;
        public final JodaCompatibleZonedDateTime scheduledTime;
        public final JodaCompatibleZonedDateTime previousScheduledTime;
        public final JodaCompatibleZonedDateTime nextScheduledTime;

        public TriggerInfo() {
            this.triggeredTime = null;
            this.scheduledTime = null;
            this.previousScheduledTime = null;
            this.nextScheduledTime = null;
        }

        public TriggerInfo(JodaCompatibleZonedDateTime triggeredTime, JodaCompatibleZonedDateTime scheduledTime, JodaCompatibleZonedDateTime previousScheduledTime, JodaCompatibleZonedDateTime nextScheduledTime) {
            this.triggeredTime = triggeredTime;
            this.scheduledTime = scheduledTime;
            this.previousScheduledTime = previousScheduledTime;
            this.nextScheduledTime = nextScheduledTime;
        }

        public TriggerInfo(Date triggeredTime, Date scheduledTime, Date previousScheduledTime, Date nextScheduledTime) {
            this.triggeredTime = WatchExecutionContextData.toJoda(triggeredTime);
            this.scheduledTime = WatchExecutionContextData.toJoda(scheduledTime);
            this.previousScheduledTime = WatchExecutionContextData.toJoda(previousScheduledTime);
            this.nextScheduledTime = WatchExecutionContextData.toJoda(nextScheduledTime);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("triggered_time", this.triggeredTime != null ? DateTimeFormatter.ISO_ZONED_DATE_TIME.format(this.triggeredTime.getZonedDateTime()) : null);
            builder.field("scheduled_time", this.scheduledTime != null ? DateTimeFormatter.ISO_ZONED_DATE_TIME.format(this.scheduledTime.getZonedDateTime()) : null);
            builder.field("previous_scheduled_time", this.previousScheduledTime != null ? DateTimeFormatter.ISO_ZONED_DATE_TIME.format(this.previousScheduledTime.getZonedDateTime()) : null);
            builder.field("next_scheduled_time", this.nextScheduledTime != null ? DateTimeFormatter.ISO_ZONED_DATE_TIME.format(this.nextScheduledTime.getZonedDateTime()) : null);
            builder.endObject();
            return builder;
        }

        public Map<String, Object> toMap() {
            return ObjectTreeXContent.toMap((ToXContent)this);
        }

        public static TriggerInfo create(DocNode jsonNode) {
            JodaCompatibleZonedDateTime triggeredTime = null;
            JodaCompatibleZonedDateTime scheduledTime = null;
            JodaCompatibleZonedDateTime previousScheduledTime = null;
            JodaCompatibleZonedDateTime nextScheduledTime = null;
            if (jsonNode.hasNonNull("triggered_time")) {
                triggeredTime = WatchExecutionContextData.parseJodaCompatibleZonedDateTime(jsonNode.getAsString("triggered_time"));
            }
            if (jsonNode.hasNonNull("scheduled_time")) {
                scheduledTime = WatchExecutionContextData.parseJodaCompatibleZonedDateTime(jsonNode.getAsString("scheduled_time"));
            }
            if (jsonNode.hasNonNull("previous_scheduled_time")) {
                previousScheduledTime = WatchExecutionContextData.parseJodaCompatibleZonedDateTime(jsonNode.getAsString("previous_scheduled_time"));
            }
            if (jsonNode.hasNonNull("next_scheduled_time")) {
                nextScheduledTime = WatchExecutionContextData.parseJodaCompatibleZonedDateTime(jsonNode.getAsString("next_scheduled_time"));
            }
            return new TriggerInfo(triggeredTime, scheduledTime, previousScheduledTime, nextScheduledTime);
        }

        public JodaCompatibleZonedDateTime getTriggeredTime() {
            return this.triggeredTime;
        }

        public JodaCompatibleZonedDateTime getScheduledTime() {
            return this.scheduledTime;
        }

        public JodaCompatibleZonedDateTime getPreviousScheduledTime() {
            return this.previousScheduledTime;
        }

        public JodaCompatibleZonedDateTime getNextScheduledTime() {
            return this.nextScheduledTime;
        }

        public JodaCompatibleZonedDateTime getTriggered_time() {
            return this.triggeredTime;
        }

        public JodaCompatibleZonedDateTime getScheduled_time() {
            return this.scheduledTime;
        }

        public JodaCompatibleZonedDateTime getPrevious_scheduled_time() {
            return this.previousScheduledTime;
        }

        public JodaCompatibleZonedDateTime getNext_scheduled_time() {
            return this.nextScheduledTime;
        }
    }
}

